#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using RPC = gov.va.med.vbecs.DAL.VAL.RPC;
#endregion

namespace gov.va.med.vbecs.VAL.UnitTests
{

	[TestFixture]
	public class VAL_VbecsPatientData : BaseTest 
	{
		
		public const string PATIENT_SELECT_STATEMENT = 
			"SELECT " + Common.VbecsTables.Patient.VistaPatientId + " FROM " + Common.VbecsTables.Patient.TableName + " WHERE BLoodTypeCode IS NOT NULL";
		
		public const string PATIENT_REPORT_UNIT_SELECT_STATEMENT = 
			"SELECT DISTINCT Patient.VistAPatientId FROM UnitStatus " 
			+ "INNER JOIN dbo.BloodUnitStatusCodeCurrent ON dbo.UnitStatus.UnitStatusCode = dbo.BloodUnitStatusCodeCurrent.UnitStatusCode "
			+ "INNER JOIN dbo.BloodUnit ON dbo.BloodUnitStatusCodeCurrent.BloodUnitGUID = dbo.BloodUnit.BloodUnitGUID "
			+ "LEFT OUTER JOIN dbo.IssuedUnit ON dbo.BloodUnit.BloodUnitGuid = dbo.IssuedUnit.BloodUnitGuid "
			+ "INNER JOIN dbo.OrderedUnit ON dbo.BloodUnit.BloodUnitGUID = dbo.OrderedUnit.BloodUnitGUID "
			+ "INNER JOIN dbo.OrderedComponent ON dbo.OrderedUnit.OrderedComponentGUID = dbo.OrderedComponent.OrderedComponentGUID "
			+ "INNER JOIN dbo.PatientOrder ON dbo.OrderedComponent.PatientOrderGUID = dbo.PatientOrder.PatientOrderGUID "
			+ "INNER JOIN dbo.PatientTreatment ON dbo.PatientOrder.PatientTreatmentGUID = dbo.PatientTreatment.PatientTreatmentGUID "
			+ "INNER JOIN dbo.Patient ON dbo.PatientTreatment.PatientGUID = dbo.Patient.PatientGUID "
			+ "INNER JOIN dbo.BloodProduct ON dbo.BloodUnit.BloodProductGUID = dbo.BloodProduct.BloodProductGUID "
			+ "INNER JOIN dbo.ProductType ON dbo.BloodProduct.ProductTypeCode = dbo.ProductType.ProductTypeCode "
			+ "INNER JOIN dbo.VamcDivision ON dbo.BloodUnit.DivisionCode = dbo.VamcDivision.DivisionCode "
			+ "INNER JOIN dbo.BloodUnitMedia ON dbo.BloodUnit.BloodUnitGUID = dbo.BloodUnitMedia.BloodUnitGUID";
		
		public const string PATIENT_TRANSFUSION_HISTOR_SELECT_STATEMENT = 
			"SELECT DISTINCT Patient.VistAPatientId FROM dbo.PatientTransfusion PatTrans "
			+ "INNER JOIN dbo.BloodUnit ON PatTrans.BloodUnitGuid = dbo.BloodUnit.BloodUnitGuid "
			+ "INNER JOIN dbo.BloodProduct ON dbo.BloodUnit.BloodProductGuid = dbo.BloodProduct.BloodProductGuid "
			+ "INNER JOIN dbo.ProductType ON dbo.BloodProduct.ProductTypeCode = dbo.ProductType.ProductTypeCode "
			+ "INNER JOIN dbo.Patient ON PatTrans.PatientGuid = dbo.Patient.PatientGuid";
	
		public const string PATIENT_SPECIMEN_SELECT_STATEMENT = 
			"SELECT DISTINCT Patient.VistAPatientId FROM dbo.BloodTestType "
			+ "INNER JOIN dbo.SpecimenTest ON dbo.BloodTestType.BloodTestTypeId = dbo.SpecimenTest.BloodTestTypeId "
			+ "INNER JOIN dbo.TestResult ON dbo.TestResult.TestResultId = dbo.SpecimenTest.TestResultId "
			+ "INNER JOIN dbo.VbecsUser ON dbo.SpecimenTest.EntryTechId = dbo.VbecsUser.VbecsUserId "
			+ "INNER JOIN dbo.OrderedTest ON dbo.SpecimenTest.OrderedTestGuid = dbo.OrderedTest.OrderedTestGuid "
			+ "INNER JOIN dbo.PatientOrder ON dbo.OrderedTest.PatientOrderGuid = dbo.PatientOrder.PatientOrderGuid "
			+ "INNER JOIN dbo.PatientTreatment ON dbo.PatientOrder.PatientTreatmentGuid = dbo.PatientTreatment.PatientTreatmentGuid "
			+ "INNER JOIN dbo.Patient ON dbo.PatientTreatment.PatientGuid = dbo.Patient.PatientGuid "
			+ "INNER JOIN dbo.OrderableTest ON dbo.BloodTestType.OrderableTestId = dbo.OrderableTest.OrderableTestId "
			+ "WHERE dbo.SpecimenTest.EntryTechId IS NOT NULL";
		
		public const string PATIENT_COMPONENT_REQUEST_SELECT_STATEMENT = 
			"SELECT DISTINCT Patient.VistAPatientId FROM dbo.PatientOrder "
			+ "INNER JOIN	dbo.PatientTreatment ON dbo.PatientOrder.PatientTreatmentGuid = dbo.PatientTreatment.PatientTreatmentGuid "
			+ "INNER JOIN dbo.Patient ON dbo.PatientTreatment.PatientGuid = dbo.Patient.PatientGuid "
			+ "INNER JOIN dbo.OrderedComponent ON dbo.PatientOrder.PatientOrderGuid = dbo.OrderedComponent.PatientOrderGuid "
			+ "INNER JOIN dbo.ComponentClass ON dbo.OrderedComponent.ComponentClassId = dbo.ComponentClass.ComponentClassId";
		
		public const string PATIENT_ANTIBODIES_IDENTIFIED_SELECT_STATEMENT = 
			"SELECT DISTINCT Patient.VistAPatientId FROM dbo.InformationMessage, Patient "
			+ "INNER JOIN dbo.PatientTransfusionRequirement ON dbo.PatientTransfusionRequirement.PatientGUID = Patient.PatientGUID "
			+ "INNER JOIN dbo.AntibodyType ON dbo.AntibodyType.AntibodyTypeID = dbo.PatientTransfusionRequirement.AntibodyTypeID "
			+ "WHERE dbo.InformationMessage.InformationMessageId = 2302 "
			+ "AND dbo.AntibodyType.AntibodyTypeId != 1 "
			+ "AND dbo.AntibodyType.AntibodyTypeId != 4 "
			+ "AND dbo.PatientTransfusionRequirement.RecordStatusCode IN ( 'A', 'C', 'H' )";
		
		public DataTable dtPatient;
		public RPC.VbecsPatientData _testVbecsPatientDataRpc;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			dtPatient = UnitTestUtil.RunSQLGetDataTable(PATIENT_SELECT_STATEMENT);
			_testVbecsPatientDataRpc = new RPC.VbecsPatientData();
		}

		[Test]
		public void Ctor_Pass()
		{
			Assert.IsNotNull( _testVbecsPatientDataRpc );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void Ctor_Fail() {}

		[Test]
		public void GetPatientAboRh_Pass_1()
		{
			bool unitTestSucceeded = false;
			if(dtPatient.Rows.Count > 0)
			{
				for( int i=0; (i < dtPatient.Rows.Count ) && (!unitTestSucceeded); i++)
				{
					string xmlString = _testVbecsPatientDataRpc.GetPatientAboRh(dtPatient.Rows[i][Common.VbecsTables.Patient.VistaPatientId].ToString());
					Assert.IsNotNull(xmlString);
					DataSet ds = RpcFunctionUnitTestUtility_VAL.LoadXmlStringIntoDataSet(xmlString);
					unitTestSucceeded = GetVbecsPatientDataUnitTest(ds, "Patient", null);
				}
			}
			Assert.IsTrue(unitTestSucceeded);
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetPatientAboRh_Fail_1()
		{
			_testVbecsPatientDataRpc.GetPatientAboRh(null);
		}

		[Test]
		public void GetTransfusionReactionHistory_Pass_1()
		{
			string select = "SELECT DISTINCT Patient.VistAPatientId FROM PatientTransfusionReaction PTR JOIN Patient ON Patient.PatientGuid = PTR.PatientGuid";
			DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable(select);
			if (dtPatient.Rows.Count == 0)
			{
				new BOL.UnitTests.BOL_PatientTransfusionReaction().SaveImplicatedBloodUnits_Pass();
				dtPatient = UnitTestUtil.RunSQLGetDataTable(select);
			}
			bool unitTestSucceeded = false;
			if(dtPatient.Rows.Count > 0)
			{
				for( int i=0; (i < dtPatient.Rows.Count ) && (!unitTestSucceeded); i++)
				{
					string xmlString = _testVbecsPatientDataRpc.GetTransfusionReactionHistory(dtPatient.Rows[i][Common.VbecsTables.Patient.VistaPatientId].ToString());
					Assert.IsNotNull(xmlString);
					DataSet ds = RpcFunctionUnitTestUtility_VAL.LoadXmlStringIntoDataSet(xmlString);
					unitTestSucceeded = ds.Tables.Contains("TransfusionReaction");
				}
			}
			Assert.IsTrue(unitTestSucceeded);

		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetTransfusionReactionHistory_Fail_1()
		{
			_testVbecsPatientDataRpc.GetTransfusionReactionHistory(null);
		}

		[Test]
		public void GetAntibodies_Pass_1()
		{
			Guid patientGuid = (Guid)(UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 PatientGuid FROM Patient")["PatientGuid"]);
			BOL.Patient patient = new BOL.Patient(patientGuid);
			//
			DataTable dtPatientAb = UnitTestUtil.RunSQLGetDataTable(PATIENT_ANTIBODIES_IDENTIFIED_SELECT_STATEMENT);
			if(dtPatientAb.Rows.Count == 0)
			{
				DataTable dtInsertTransfusionRequirements = BOL.PatientTransfusionRequirement.InitializeTransfusionRequirementsTable(false);
				DataRow drNewTR = dtInsertTransfusionRequirements.NewRow();
				//
				drNewTR[Common.VbecsTables.PatientTransfusionRequirement.PatientTransfusionRequirementGuid] = System.Guid.NewGuid();
				drNewTR[Common.VbecsTables.PatientSpecialInstruction.PatientGuid] = patient.PatientGuid;
				drNewTR[Common.VbecsTables.PatientTransfusionRequirement.TransfusionRequirementText] = "Antibody thingy";
				drNewTR[Common.VbecsTables.PatientTransfusionRequirement.TransfusionRequirementCategoryCode] = Common.Utility.GetTransfusionCategoryCodeFromEnum( Common.TransfusionRequirementCategoryCode.AntibodyIdentified );
				drNewTR[Common.VbecsTables.PatientTransfusionRequirement.CreateDate] = DateTime.UtcNow;
				drNewTR[Common.VbecsTables.PatientTransfusionRequirement.CreateUser] = "TESTER";
				drNewTR[Common.VbecsTables.PatientTransfusionRequirement.CreateDivisionCode] = Common.LogonUser.LogonUserDivisionCode;
				drNewTR[Common.VbecsTables.PatientTransfusionRequirement.VistaConversionIndicator] = false;
				drNewTR[Common.VbecsTables.PatientTransfusionRequirement.AntibodyTypeId] = 2;
				drNewTR[Common.VbecsTables.PatientTransfusionRequirement.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
				drNewTR[Common.VbecsTables.PatientTransfusionRequirement.LastUpdateUser] = "TESTER";
				drNewTR[Common.VbecsTables.PatientTransfusion.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
				dtInsertTransfusionRequirements.Rows.Add(drNewTR);
				//
				System.Collections.ArrayList dtArrayList = new System.Collections.ArrayList();
				System.Collections.ArrayList sprocArrayList = new System.Collections.ArrayList();
				//
				dtArrayList.Add(Common.Utility.AppendLastUpdateInformation(dtInsertTransfusionRequirements, Common.UpdateFunction.UnitTests));
				sprocArrayList.Add(Common.VbecsStoredProcs.InsertTransfusionRequirements.StoredProcName);
				//
				DAL.Patient.SaveSIsAndTRs(sprocArrayList, dtArrayList);
				//
				dtPatientAb = UnitTestUtil.RunSQLGetDataTable(PATIENT_ANTIBODIES_IDENTIFIED_SELECT_STATEMENT);
				Assert.IsTrue(dtPatientAb.Rows.Count > 0, "No test data!");
			}
			//
			bool unitTestSucceeded = false;
			if(dtPatientAb.Rows.Count > 0)
			{
				for( int i=0; (i < dtPatientAb.Rows.Count ) && (!unitTestSucceeded); i++)
				{
					string xmlString = _testVbecsPatientDataRpc.GetAntibodies(dtPatientAb.Rows[i][Common.VbecsTables.Patient.VistaPatientId].ToString());
					Assert.IsNotNull(xmlString);
					DataSet ds = RpcFunctionUnitTestUtility_VAL.LoadXmlStringIntoDataSet(xmlString);
					unitTestSucceeded = ds.Tables.Contains("Antibody");
				}
			}
			Assert.IsTrue(unitTestSucceeded);

		}


		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetAntibodies_Fail_1()
		{
			_testVbecsPatientDataRpc.GetAntibodies(null);
		}

		[Test]
		public void GetAvailableUnits_Autologous_Pass()
		{
			bool unitTestSucceeded = false;
			//
			//Insert autologous unit and assign to patient to guarantee success
			DataRow drPatient = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM Patient ORDER BY LastUpdateDate DESC");
			Guid patientGuid = (Guid)drPatient[Common.VbecsTables.Patient.PatientGuid];
			Guid bloodUnitGuid = Guid.NewGuid();
			DataRow drProduct = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM BloodProduct WHERE ProductCode = '04210' AND RecordStatusCode = 'A'");
			Guid bloodProductGuid = (Guid)drProduct[TABLES.BloodProduct.BloodProductGuid];
			DataCreator.CreateAutologousBloodUnit(bloodUnitGuid,Guid.NewGuid(),patientGuid,bloodProductGuid);
			Guid patientTreatmentGuid = Guid.NewGuid();
			DataCreator.InsertPatientTreatment(patientTreatmentGuid, patientGuid);
			Guid patientOrderGuid = Guid.NewGuid();
			DataCreator.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);
			Guid orderedComponentGuid = Guid.NewGuid();
			DataCreator.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);
			Guid orderedUnitGuid = Guid.NewGuid();
			DataCreator.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);
			//
			string xmlString = _testVbecsPatientDataRpc.GetAvailableUnits(drPatient[Common.VbecsTables.Patient.VistaPatientId].ToString());
			Assert.IsNotNull(xmlString);
			// Save the xml to file for M unit testing documentation.
//			RpcFunctionUnitTestUtility_VAL.SaveXmlToFile("D:/VbecsPatientData_GetAvailableUnits_Autologous_Pass.xml",xmlString);
			DataSet ds = RpcFunctionUnitTestUtility_VAL.LoadXmlStringIntoDataSet(xmlString);
//			ds.ReadXml("D:/VbecsPatientData_GetAvailableUnits_Autologous_Pass.xml", XmlReadMode.InferSchema);
			unitTestSucceeded = GetVbecsPatientDataUnitTest(ds, "Unit", "A");
			//
			Assert.IsTrue(unitTestSucceeded,"Autologous unit");
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetAvailableUnits_Fail_1()
		{
			_testVbecsPatientDataRpc.GetAvailableUnits(null);
		}

		[Test]
		public void GetAvailableUnits_Assigned_Pass()
		{
			bool unitTestSucceeded = false;
			//
			//Insert autologous unit and assign to patient to guarantee success
			DataRow drPatient = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM Patient ORDER BY LastUpdateDate DESC");
			Guid patientGuid = (Guid)drPatient[Common.VbecsTables.Patient.PatientGuid];
			Guid bloodUnitGuid = Guid.NewGuid();
			DataRow drProduct = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM BloodProduct WHERE ProductCode = '04210' AND RecordStatusCode = 'A'");
			Guid bloodProductGuid = (Guid)drProduct[TABLES.BloodProduct.BloodProductGuid];
			DataCreator.CreateBloodUnit(bloodUnitGuid,Guid.NewGuid(),patientGuid,bloodProductGuid, true);
			Guid patientTreatmentGuid = Guid.NewGuid();
			DataCreator.InsertPatientTreatment(patientTreatmentGuid, patientGuid);
			Guid patientOrderGuid = Guid.NewGuid();
			DataCreator.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);
			Guid orderedComponentGuid = Guid.NewGuid();
			DataCreator.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);
			Guid orderedUnitGuid = Guid.NewGuid();
			string insertOrderedUnit = "INSERT INTO ORDEREDUNIT (";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedComponentGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.BloodUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.SelectedDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.SelectedTechId + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchRequiredIndicator + ",";
			insertOrderedUnit += TABLES.OrderedUnit.RecordStatusCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.DivisionCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateUser + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateFunctionId + ")";
			insertOrderedUnit += "VALUES (";
			insertOrderedUnit += "'" + orderedUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedUnit += "'" + bloodUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "'" + Environment.UserName + "',";
			insertOrderedUnit += "1,";
			insertOrderedUnit += "'A',";
			insertOrderedUnit += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "'" + Environment.UserName + "',";
			insertOrderedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			UnitTestUtil.RunSQL(insertOrderedUnit);
			//
			string xmlString = _testVbecsPatientDataRpc.GetAvailableUnits(drPatient[Common.VbecsTables.Patient.VistaPatientId].ToString());
			Assert.IsNotNull(xmlString);
			// Save the xml to file for M unit testing documentation.
//			RpcFunctionUnitTestUtility_VAL.SaveXmlToFile("D:/VbecsPatientData_GetAvailableUnits_Assigned_Pass.xml",xmlString);
			DataSet ds = RpcFunctionUnitTestUtility_VAL.LoadXmlStringIntoDataSet(xmlString);
//			ds.ReadXml("D:/VbecsPatientData_GetAvailableUnits_Assigned_Pass.xml", XmlReadMode.InferSchema);
			unitTestSucceeded = GetVbecsPatientDataUnitTest(ds, "Unit", "S");
			//
			Assert.IsTrue(unitTestSucceeded,"Assigned unit");
		}

		[Test]
		public void GetAvailableUnits_Directed_Pass()
		{
			bool unitTestSucceeded = false;
			//
			//Insert directed unit and assign to patient to guarantee success
			DataRow drPatient = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM Patient ORDER BY LastUpdateDate DESC");
			Guid patientGuid = (Guid)drPatient[Common.VbecsTables.Patient.PatientGuid];
			Guid bloodUnitGuid = Guid.NewGuid();
			DataRow drProduct = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM BloodProduct WHERE ProductCode = '04210' AND RecordStatusCode = 'A'");
			Guid bloodProductGuid = (Guid)drProduct[TABLES.BloodProduct.BloodProductGuid];
			DataCreator.CreateDirectedBloodUnit(bloodUnitGuid,Guid.NewGuid(),patientGuid,bloodProductGuid);
			Guid patientTreatmentGuid = Guid.NewGuid();
			DataCreator.InsertPatientTreatment(patientTreatmentGuid, patientGuid);
			Guid patientOrderGuid = Guid.NewGuid();
			DataCreator.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);
			Guid orderedComponentGuid = Guid.NewGuid();
			DataCreator.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);
			Guid orderedUnitGuid = Guid.NewGuid();
			DataCreator.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);
			//
			string xmlString = _testVbecsPatientDataRpc.GetAvailableUnits(drPatient[Common.VbecsTables.Patient.VistaPatientId].ToString());
			Assert.IsNotNull(xmlString);
			// Save the xml to file for M unit testing documentation.
//			RpcFunctionUnitTestUtility_VAL.SaveXmlToFile("D:/VbecsPatientData_GetAvailableUnits_Directed_Pass.xml",xmlString);
			DataSet ds = RpcFunctionUnitTestUtility_VAL.LoadXmlStringIntoDataSet(xmlString);
//			ds.ReadXml("D:/VbecsPatientData_GetAvailableUnits_Directed_Pass.xml", XmlReadMode.InferSchema);
			unitTestSucceeded = GetVbecsPatientDataUnitTest(ds, "Unit", "D");
			//
			Assert.IsTrue(unitTestSucceeded,"Directed unit");

		}

		[Test]
		public void GetAvailableUnits_Crossmatched_Pass()
		{
			bool unitTestSucceeded = false;
			//
			//Insert autologous unit and assign to patient to guarantee success
			DataRow drPatient = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM Patient ORDER BY LastUpdateDate DESC");
			Guid patientGuid = (Guid)drPatient[Common.VbecsTables.Patient.PatientGuid];
			Guid bloodUnitGuid = Guid.NewGuid();
			DataRow drProduct = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM BloodProduct WHERE ProductCode = '04210' AND RecordStatusCode = 'A'");
			Guid bloodProductGuid = (Guid)drProduct[TABLES.BloodProduct.BloodProductGuid];
			DataCreator.CreateBloodUnit(bloodUnitGuid,Guid.NewGuid(),patientGuid,bloodProductGuid, true);
			Guid patientTreatmentGuid = Guid.NewGuid();
			DataCreator.InsertPatientTreatment(patientTreatmentGuid, patientGuid);
			Guid patientOrderGuid = Guid.NewGuid();
			DataCreator.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);
			Guid orderedComponentGuid = Guid.NewGuid();
			DataCreator.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);
			Guid orderedUnitGuid = Guid.NewGuid();
			DataCreator.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);
			//
			string xmlString = _testVbecsPatientDataRpc.GetAvailableUnits(drPatient[Common.VbecsTables.Patient.VistaPatientId].ToString());
			Assert.IsNotNull(xmlString);
			// Save the xml to file for M unit testing documentation.
//			RpcFunctionUnitTestUtility_VAL.SaveXmlToFile("D:/VbecsPatientData_GetAvailableUnits_Crossmatched_Pass.xml",xmlString);
			DataSet ds = RpcFunctionUnitTestUtility_VAL.LoadXmlStringIntoDataSet(xmlString);
//			ds.ReadXml("D:/VbecsPatientData_GetAvailableUnits_Crossmatched_Pass.xml", XmlReadMode.InferSchema);
			unitTestSucceeded = GetVbecsPatientDataUnitTest(ds, "Unit", "C");
			//
			Assert.IsTrue(unitTestSucceeded,"Crossmatched unit");
		}

		[Test]
		public void GetAvailableUnits_Issued_Pass()
		{
			bool unitTestSucceeded = false;
			//
			//Insert autologous unit and assign to patient to guarantee success
			DataRow drPatient = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM Patient ORDER BY LastUpdateDate DESC");
			Guid patientGuid = (Guid)drPatient[Common.VbecsTables.Patient.PatientGuid];
			Guid bloodUnitGuid = Guid.NewGuid();
			DataRow drProduct = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM BloodProduct WHERE ProductCode = '04210' AND RecordStatusCode = 'A'");
			Guid bloodProductGuid = (Guid)drProduct[TABLES.BloodProduct.BloodProductGuid];
			DataCreator.CreateBloodUnit(bloodUnitGuid,Guid.NewGuid(),patientGuid,bloodProductGuid, true);
			Guid patientTreatmentGuid = Guid.NewGuid();
			DataCreator.InsertPatientTreatment(patientTreatmentGuid, patientGuid);
			Guid patientOrderGuid = Guid.NewGuid();
			DataCreator.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);
			Guid orderedComponentGuid = Guid.NewGuid();
			DataCreator.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);
			Guid orderedUnitGuid = Guid.NewGuid();
			DataCreator.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);
			Guid issuedUnitGuid = Guid.NewGuid();
			DataCreator.InsertIssuedUnit(issuedUnitGuid, bloodUnitGuid);
			//
			string xmlString = _testVbecsPatientDataRpc.GetAvailableUnits(drPatient[Common.VbecsTables.Patient.VistaPatientId].ToString());
			Assert.IsNotNull(xmlString);
			// Save the xml to file for M unit testing documentation.
//			RpcFunctionUnitTestUtility_VAL.SaveXmlToFile("D:/VbecsPatientData_GetAvailableUnits_Issued_Pass.xml",xmlString);
			DataSet ds = RpcFunctionUnitTestUtility_VAL.LoadXmlStringIntoDataSet(xmlString);
//			ds.ReadXml("D:/VbecsPatientData_GetAvailableUnits_Issued_Pass.xml", XmlReadMode.InferSchema);
			unitTestSucceeded = GetVbecsPatientDataUnitTest(ds, "Unit", "I");
			//
			Assert.IsTrue(unitTestSucceeded,"Issued unit");
		}

		[Test]
		public void GetTransfusionHistory_Pass()
		{
			DataTable dtPatientTran = UnitTestUtil.RunSQLGetDataTable(PATIENT_TRANSFUSION_HISTOR_SELECT_STATEMENT);
			bool unitTestSucceeded = false;
			if(dtPatientTran.Rows.Count > 0)
			{
				for( int i=0; (i < dtPatientTran.Rows.Count ) && (!unitTestSucceeded); i++)
				{
					string xmlString = _testVbecsPatientDataRpc.GetTransfusionHistory(dtPatientTran.Rows[i][Common.VbecsTables.Patient.VistaPatientId].ToString());
					Assert.IsNotNull(xmlString);
					// Save the xml to file for M unit testing documentation.
//					RpcFunctionUnitTestUtility_VAL.SaveXmlToFile("D:/VbecsPatientData_GetTransfusionHistory_Pass_1.xml",xmlString);
					DataSet ds = RpcFunctionUnitTestUtility_VAL.LoadXmlStringIntoDataSet(xmlString);
//					ds.ReadXml("D:/VbecsPatientData_GetTransfusionHistory_Pass_1.xml", XmlReadMode.InferSchema);
					unitTestSucceeded = GetVbecsPatientDataUnitTest(ds, "Transfusion", null);
				}
			}
			Assert.IsTrue(unitTestSucceeded);

		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetTransfusionHistory_Fail_1()
		{
			_testVbecsPatientDataRpc.GetTransfusionHistory(null);
		}

		[Test]
		public void GetPatientReportData_Pass_1()
		{
			Guid patientGuid = DataCreator.GetRandomRecordGuid(TABLES.Patient.TableName, "LastUpdateFunctionid = 0");

			BOL.UnitTests.BOL_SpecimenTest.BuildABORhFromSpecimenTests(patientGuid, Guid.NewGuid(), Guid.NewGuid(), Guid.NewGuid(), Guid.NewGuid(), Guid.NewGuid(), Guid.NewGuid(), "A","P");
			DataTable dtPatientSpecimen = UnitTestUtil.RunSQLGetDataTable(PATIENT_SPECIMEN_SELECT_STATEMENT, true);

			bool unitTestSucceeded = false;
			Assert.AreEqual(false, dtPatient.Rows.Count == 0, "Need Specimen Results");

			if(dtPatientSpecimen.Rows.Count > 0)
			{
				for( int i=0; (i < dtPatientSpecimen.Rows.Count ) && (!unitTestSucceeded); i++)
				{
					string xmlString = _testVbecsPatientDataRpc.GetPatientReportData(dtPatientSpecimen.Rows[i][Common.VbecsTables.Patient.VistaPatientId].ToString());
					Assert.IsNotNull(xmlString);
					// Save the xml to file for M unit testing documentation.
//					RpcFunctionUnitTestUtility_VAL.SaveXmlToFile("D:/VbecsPatientData_GetPatientReportData_Pass_1.xml",xmlString);
					DataSet ds = RpcFunctionUnitTestUtility_VAL.LoadXmlStringIntoDataSet(xmlString);
//					ds.ReadXml("D:/VbecsPatientData_GetPatientReportData_Pass_1.xml", XmlReadMode.InferSchema);
					unitTestSucceeded = GetVbecsPatientDataUnitTest(ds, "SpecimenTest", null);
				}
			}
			Assert.AreEqual(true, unitTestSucceeded, "Success");

		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetPatientReportData_Fail_1()
		{
			_testVbecsPatientDataRpc.GetPatientReportData(null);
		}

		[Test]
		public void GetPatientReportData_Pass_2()
		{
			DataTable dtPatientComp = UnitTestUtil.RunSQLGetDataTable(PATIENT_COMPONENT_REQUEST_SELECT_STATEMENT);
			//
			if(dtPatientComp.Rows.Count == 0)
			{
				DataCreator.CreateIssuedBloodUnit(true);
				dtPatientComp = UnitTestUtil.RunSQLGetDataTable(PATIENT_COMPONENT_REQUEST_SELECT_STATEMENT);
				Assert.IsTrue(dtPatientComp.Rows.Count > 0, "No test data for GetPatientReportData_Pass_2()");
			}
			//
			bool unitTestSucceeded = false;
			if(dtPatientComp.Rows.Count > 0)
			{
				for( int i=0; (i < dtPatientComp.Rows.Count ) && (!unitTestSucceeded); i++)
				{
					string xmlString = _testVbecsPatientDataRpc.GetPatientReportData(dtPatientComp.Rows[i][Common.VbecsTables.Patient.VistaPatientId].ToString());
					Assert.IsNotNull(xmlString);
					// Save the xml to file for M unit testing documentation.
//					RpcFunctionUnitTestUtility_VAL.SaveXmlToFile("D:/VbecsPatientData_GetPatientReportData_Pass_2.xml",xmlString);
					DataSet ds = RpcFunctionUnitTestUtility_VAL.LoadXmlStringIntoDataSet(xmlString);
//					ds.ReadXml("D:/VbecsPatientData_GetPatientReportData_Pass_2.xml", XmlReadMode.InferSchema);
					unitTestSucceeded = GetVbecsPatientDataUnitTest(ds, "ComponentRequest", null);
				}
			}
			Assert.IsTrue(unitTestSucceeded);

		}

		[Test]
		public void GetPatientReportData_Pass_3()
		{
			
			DataTable dtPatientUnits = UnitTestUtil.RunSQLGetDataTable(PATIENT_REPORT_UNIT_SELECT_STATEMENT);
			//
			if(dtPatientUnits.Rows.Count == 0)
			{
				DataCreator.CreateCrossmatchedBloodUnitTestData();
				dtPatientUnits = UnitTestUtil.RunSQLGetDataTable(PATIENT_REPORT_UNIT_SELECT_STATEMENT);
				Assert.IsTrue(dtPatientUnits.Rows.Count > 0, "No test data for GetPatientReportData_Pass_3()");
			}

			Assert.IsTrue(dtPatientUnits.Rows.Count > 0);


		}

		private bool GetVbecsPatientDataUnitTest(DataSet ds, string tableName, string unitStatusCode)
		{
			bool valueFound = false;

			for(int i=0; (i < ds.Tables.Count ) && (!valueFound); i++)
			{
				if( ds.Tables[i].TableName == tableName )
				{
					for(int j=0; j < ds.Tables[i].Rows.Count; j++)
					{
						switch(tableName)
						{
							case "Patient":
								if((ds.Tables[i].Columns.Contains("abo")) && 
									(ds.Tables[i].Columns.Contains("rh")) && 
									(ds.Tables[i].Columns.Contains("dfn")) && 
									(ds.Tables[i].Columns.Contains("firstName")) && 
									(ds.Tables[i].Columns.Contains("lastName")) && 
									(ds.Tables[i].Columns.Contains("ssn")))
									valueFound = true;
								break;

							case "TransfusionReaction":
								if( (ds.Tables[i].Columns.Contains("type")) && 
									(ds.Tables[i].Columns.Contains("date")) &&
									(ds.Tables[i].Columns.Contains("unitId")) &&
									(ds.Tables[i].Columns.Contains("productTypeName")) &&
									(ds.Tables[i].Columns.Contains("productTypePrintName")) )
									valueFound = true;
								break;
								
							case "Antibody":
								if( (ds.Tables[i].Columns.Contains("name")) )
									valueFound = true;
								break;

							case "Unit":
								if( (ds.Tables[i].Columns.Contains("status")) && 
									(ds.Tables[i].Columns.Contains("id")) && 
									(ds.Tables[i].Columns.Contains("product")) && 
									(ds.Tables[i].Columns.Contains("abo")) &&
									(ds.Tables[i].Columns.Contains("rh")) &&
									(ds.Tables[i].Columns.Contains("divisionCode")) &&
									(ds.Tables[i].Columns.Contains("expDate")) && 
									(ds.Tables[i].Rows[j]["status"].ToString() == unitStatusCode))
									valueFound = true;
								break;

							case "Transfusion":
								if( (ds.Tables[i].Columns.Contains("date")) &&
									(ds.Tables[i].Columns.Contains("productTypeName")) &&
									(ds.Tables[i].Columns.Contains("productTypePrintName")))
									valueFound = true;
								break;


							case "SpecimenTest":
								if( (ds.Tables[i].Columns.Contains("printTestName")) && 
									(ds.Tables[i].Columns.Contains("orderableTestName")) &&
									(ds.Tables[i].Columns.Contains("result")) &&
									(ds.Tables[i].Columns.Contains("testDate")) &&
									(ds.Tables[i].Columns.Contains("cprsOrderId")) &&
									(ds.Tables[i].Columns.Contains("divisionCode")) &&
									(ds.Tables[i].Columns.Contains("enteringTechId")) &&
									(ds.Tables[i].Columns.Contains("requestorId")) )
									valueFound = true;
								break;

							case "ComponentRequest":
								if( (ds.Tables[i].Columns.Contains("dateRequested")) && 
									(ds.Tables[i].Columns.Contains("dateWanted")) &&
									(ds.Tables[i].Columns.Contains("cprsOrderId")) &&
									(ds.Tables[i].Columns.Contains("componentClassName")) &&
									(ds.Tables[i].Columns.Contains("componentClassShortName")) &&
									(ds.Tables[i].Columns.Contains("requestorId")) &&
									(ds.Tables[i].Columns.Contains("enteredById")) )
									valueFound = true;
								break;

							default:
								break;
						}
					}
				}
			}
			return valueFound;
		}
	}
}
#endif
